/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __CONFSCAN_H
#define __CONFSCAN_H

#ifndef CLI
#define CLI
#endif

#include "confdefs.h"


typedef struct {
  b_int32	addr;
  
  union {
    b_int32	cfg_reg [16];

    struct {
      b_int16	vendor_id,
		device_id;

#if 0
    
      struct {
	b_int16	io_space : 1;
	b_int16	memory_space : 1;
	b_int16	bus_master : 1;
	b_int16	special_cycles : 1;
	b_int16	mwi_enable : 1;
	b_int16	vga_palette_snoop : 1;
	b_int16	parity_error_response : 1;
	b_int16	wait_cycle_control : 1;
	b_int16	serr_enable : 1;
	b_int16	fast_back_enable : 1;
	b_int16	reserved : 6;
      } command;

      struct {
	b_int16	reserved : 5;
	b_int16	sixsix_capable : 1;
	b_int16	udf_supported : 1;
	b_int16	fast_back_capable : 1;
	b_int16	perr_detected : 1;
	b_int16	devsel_timing : 2;
	b_int16	t_abort_signaled : 1;
	b_int16	t_abort_received : 1;
	b_int16	m_abort_received : 1;
	b_int16	serr_signaled : 1;
	b_int16	serr_detected : 1;
      } status;

#else
      b_int16	command,
		status;

#endif
    
      b_int32	class_code;
      b_int8	cache_line_size,
		latency_timer,
		header_type,
		self_test;
      b_int32	bar_1,
		bar_2,
		bar_3,
    		bar_4,
		bar_5,
		bar_6;
      b_int32	cardbus_pointer;
      b_int16	subsystem_vendor_id,
		subsystem_device_id;
      b_int32	bar_xrom;
      b_int32	reserved_1,
		reserved_2;
      b_int8	interrupt_line,
		interrupt_pin,
		min_gnt,
		max_lat;
    } cfg_fields;
  } header;
} b_configheadertype;


#ifdef __cplusplus
extern "C" {
#endif


CLI b_errtype EXPORT	BestConfigScan (				/* @cscan */
			b_handletype		handle
			);


CLI b_errtype EXPORT	BestConfigScanStatusGet (			/* @cscansget */
  			b_handletype		handle,
			b_cscanstatustype	cscanstatus,	/* @stat */
			b_int32		       *value		/* #RETURN "Value= %ld\\h\n" */
			);


b_errtype EXPORT	BestConfigScanResultGet (
  			b_handletype		handle,
			b_int32			devenum,
			b_configheadertype     *header
			);


b_errtype EXPORT	BestConfigScanResultPrint (
  			b_handletype		handle,
			b_configheadertype     *header,
			b_charptrtype	       *res_string
			);


CLI b_errtype EXPORT	BestConfigScanResultStringGet (			/* @cscanressget */
  			b_handletype		handle,
			b_int32			devenum,	/* @dev */
			b_charptrtype	       *res_string	/* #RETURN "%s" */
			);


CLI b_errtype EXPORT	BestConfigScanPrint (				/* @cscanprnt */
  			b_handletype		handle,
			b_charptrtype	       *res_string	/* #RETURN "%s" */
			);



#ifdef __cplusplus
}
#endif


#endif


